// ファイル名： Ch05/BoxLocator/Appli_Main.cc 
#include <iostream> 
#include "./units.inc" 
#include "./Box.hh" 
#include "./BoxLocator.hh" 
using namespace std; 
 
int main() { 
  BoxLocator locator = BoxLocator(); 
 
  BoxPars par_1 = {30.0*cm, 20.0*cm, 10.0*cm}; // Size: X,Y,Z 
  Box  aBox_1 = Box("Box_#1", par_1);  
  Point3D pos_1 =  {1.0*m,  -1.0*m, 2.0*m};  
  locator.placeBox(aBox_1, pos_1); 
 
  BoxPars par_2 = {10.0*mm, 20.0*mm, 30.0*mm}; // Size: X,Y,Z 
  Box  aBox_2 = Box("Box_#2", par_2);  
  Point3D pos_2 =  {1.0*m,  1.0*m, -2.0*m};  
  locator.placeBox(aBox_2, pos_2); 
 
  Point3D testPoint = {1.0*m+5.0*mm, -1.0*m, 2.0*m};  
  vector<Box> inBoxes = locator.isPointInBoxes(testPoint); 
  for (auto val : inBoxes){  
    cout << "Boxes containing testpoint: "  
         << val.getBoxName() << endl;  
  } 
}
