{
gStyle->SetPalette(1); //set pallete from violet to red
gStyle->SetCanvasDefW(1200);
gStyle->SetCanvasDefH(1000);

TFile *file = new TFile("cosmicMask.root");
TH2F *h00=file->Get("moduleOccu/OccuMap_layer0_side0_phi_vs_eta;1");
TH2F *h01=file->Get("moduleOccu/OccuMap_layer0_side1_phi_vs_eta;1");
TH2F *h10=file->Get("moduleOccu/OccuMap_layer1_side0_phi_vs_eta;1");
TH2F *h11=file->Get("moduleOccu/OccuMap_layer1_side1_phi_vs_eta;1");
h00->SetMaximum(2.0e-4);
h01->SetMaximum(2.0e-4);
h10->SetMaximum(2.0e-4);
h11->SetMaximum(2.0e-4);

TCanvas *MyC1= new TCanvas("MyC1","Pit Occupancy L0 L1");
   MyC1->Divide(2,2);
   MyC1->cd(1);
   h00.Draw("colz");
   MyC1->cd(2);
   h01.Draw("colz");
   MyC1->cd(3);
   h10.Draw("colz");
   MyC1->cd(4);
   h11.Draw("colz");
TCanvas *MyC2= new TCanvas("MyC2","Pit Occupancy L2 L3");
TH2F *h20=file->Get("moduleOccu/OccuMap_layer2_side0_phi_vs_eta;1");
TH2F *h21=file->Get("moduleOccu/OccuMap_layer2_side1_phi_vs_eta;1");
TH2F *h30=file->Get("moduleOccu/OccuMap_layer3_side0_phi_vs_eta;1");
TH2F *h31=file->Get("moduleOccu/OccuMap_layer3_side1_phi_vs_eta;1");
h20->SetMaximum(2.0e-4);
h21->SetMaximum(2.0e-4);
h30->SetMaximum(2.0e-4);
h31->SetMaximum(2.0e-4);

   MyC2->Divide(2,2);
   MyC2->cd(1);
   h20.Draw("colz");
   MyC2->cd(2);
   h21.Draw("colz");
   MyC2->cd(3);
   h30.Draw("colz");
   MyC2->cd(4);
   h31.Draw("colz");
}

