/* camlib.c */
/* CAMAC access library for ccpdrv (compatible with KEK CAMAC library) */
/* Modified for ccpdrv	(M. Suehiro)	Mon,  2 Sep 2002 18:33:49 +0900 */

/* ORIGINAL */
/* camac access library for camdrv (conpatible with KEK CAMAC library) */
/* Edited by Sanshiro E. on 23 July 1999. */
/* Last updated by Sanshiro E. on 23 July 1999. */


#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>

#include "ccpdrv.h"
#include "camlib.h"

static const char *device_file = "/dev/ccpdrv";
static int device_descripter = 0;
static unsigned ioctl_data[2];


int COPEN(void)
{
    device_descripter = open(device_file, O_RDWR);

    return (device_descripter > 0) ? 0 : -1;
}

int CCLOSE(void)
{
    close(device_descripter);

    return 0;
}

int CSETCR(int crate)
{
    if (crate == 0) {
        return 0;
    }
    else {
        /*  not implemented yet */
        return -1;
    }
}

int CGENZ(void)
{
    int result; 
    result = ioctl(device_descripter, CCPDRV_IOC_INITIALIZE, 0);

    return (result >= 0) ? 0 : -1;
}

int CGENC(void)
{
    int result; 
    result = ioctl(device_descripter, CCPDRV_IOC_CLEAR, 0);

    return (result >= 0) ? 0 : -1;
}

int CSETI(void)
{
    int result; 
    result = ioctl(device_descripter, CCPDRV_IOC_INHIBIT, 0);

    return (result >= 0) ? 0 : -1;
}

int CREMI(void)
{
    int result; 
    result = ioctl(device_descripter, CCPDRV_IOC_RELEASE_INHIBIT, 0);

    return (result >= 0) ? 0 : -1;
}

int CAMAC(int naf, int *data, int *q, int *x)
{
    int result;

    ioctl_data[0] = naf;
    ioctl_data[1] = (unsigned) *data;
    result = ioctl(device_descripter, CCPDRV_IOC_CAMAC_ACTION, ioctl_data);

    if (result < 0) {
        return result;
    }

    *data = ioctl_data[1] & 0x00ffffff;

    *q = ! (result & 0x0001);
    *x = ! (result & 0x0002);

    return 0;
}

int CAMACW(int naf, unsigned short *data, int *q, int *x)
{

    int   _data  = * data;
    int   result = CAMAC( naf, & _data, q, x );

    * data = (unsigned short) _data;

    return result;
}

int CELAM(int mask)
{
    int result; 
    result = ioctl(device_descripter, CCPDRV_IOC_ENABLE_INTERRUPT, 0);

    return (result >= 0) ? 0 : -1;
}

int CDLAM(void)
{
    int result; 
    result = ioctl(device_descripter, CCPDRV_IOC_DISABLE_INTERRUPT, 0);

    return (result >= 0) ? 0 : -1;
}

int CWLAM(int timeout)
{
    int result; 
    
    CELAM(~0);

    ioctl_data[0] = timeout;
    ioctl_data[1] = 0;
    result = ioctl(device_descripter, CCPDRV_IOC_WAIT_LAM, ioctl_data);

    return (result >= 0) ? 0 : -1;
}
