// ====================================================================
//    DetectorConstruction.hh
//
// ====================================================================
#ifndef DETECTOR_CONSTRUCTION_H
#define DETECTOR_CONSTRUCTION_H

#include "G4VUserDetectorConstruction.hh"
class G4VPhysicalVolume;
// ====================================================================
//
// class definition
//
// ====================================================================

class DetectorConstruction : public G4VUserDetectorConstruction {

public:
  DetectorConstruction();
  ~DetectorConstruction();
 
  G4double GetWorldSizeX()           {return WorldSizeX;};
  const G4VPhysicalVolume* GetCounter()   {return physiCounter;};

  void DefineMaterials();
  virtual G4VPhysicalVolume* Construct(); 
private:
     G4double           WorldSizeX;
     G4VPhysicalVolume* physiCounter; //pointer to the physical Counter
};



#endif
